#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Cafe WallMod01.fsh  by   NBickford
//https://www.shadertoy.com/view/ltjGRd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define ss 4
#define pi 3.1415926535897
#define rotation 1.

float roundf(float v, float d){
    return ceil(v/d-0.5)*d;
}


float checkerboard(vec2 uv){
    vec2 p=mod(uv-vec2(0.5),1.0);
    return mod(step(p.x,0.5)+step(p.y,0.5),2.0);
}

vec2 rot(vec2 uv, float r){
    float cr=cos(r),sr=sin(r);
    return vec2(cr*uv.x-sr*uv.y,sr*uv.x+cr*uv.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float tv=0.0;
    float t=iTime*0.67;
    
    for(int xp=0;xp<ss;xp++){
        for(int yp=0;yp<ss;yp++){
            vec2 uv = 2.0*(fragCoord.xy-iResolution.xy*0.5+vec2(xp,yp)/float(ss))/iResolution.x;
            uv*=4.0;

            //Enable to counteract the Cafe Wall effect
            //uv=rot(uv,0.01*rotation*sin(pi*t));


            uv.x=uv.x-roundf(uv.y-0.25,0.5)*t;
            float v=checkerboard(uv);

            if(abs(roundf(uv.y,0.5)-uv.y)<0.01) v=0.5;
                    tv+=v;
        }
    }
    tv=tv/float(ss*ss);
    fragColor=vec4(tv,tv,tv,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

